import processing.serial.*;

Serial myPort;
float distance = 0;
float cubeY;

void setup() {
  size(600, 600, P3D);  // Enable 3D mode
  printArray(Serial.list());  // Print available serial ports
  
  // Change to your ESP32-C3's serial port (e.g., "COM3" on Windows, "/dev/ttyUSB0" on Linux/macOS)
  myPort = new Serial(this, "COM3", 115200);  
  myPort.bufferUntil('\n');
}

void draw() {
  background(173, 216, 230); // Light blue background
  
  lights();
  
  // Flip the mapping: 0mm -> top (-200), 300mm -> bottom (200)
  cubeY = map(distance, 0, 300, 200, -200);  

  // Set perspective and camera
  translate(width/2, height/2, 0);
  
  // Draw cube
  pushMatrix();
  translate(0, cubeY, 0);  // Move cube up/down correctly
  fill(50);  // Grey color
  stroke(0);  // Black outline
  box(100);  // Cube size: 100x100x100
  popMatrix();
  
  // Display text
  fill(0);
  textSize(20);
  textAlign(CENTER);
  text("Distance: " + int(distance) + " mm", width / 2, height - 20);
}

void serialEvent(Serial myPort) {
  String data = myPort.readStringUntil('\n');
  if (data != null) {
    distance = constrain(float(trim(data)), 0, 300);  // Limit range
  }
}
